import pandas as pd   
import pickle
import numpy as np

# Load the dataset
melbourne_housing = pd.read_csv("melb_data.csv")

flemington_land_sizes = flemington_housing['Landsize']
average_land_size = np.mean(flemington_land_sizes)
plt.boxplot(flemington_land_sizes)
plt.ylabel('Land Size')
plt.title('Distribution of Land Sizes in Flemington, Australia')

plt.savefig('./ref_result/box_chart.png')
plt.show()

print(f"Average land size in Flemington, Australia: {average_land_size:.2f} square meters")
pickle.dump(average_land_size,open("./ref_result/average_land_size.pkl","wb"))
 
